﻿package 
{
	import flash.display.*;
	import flash.media.*;
	import flash.events.*;
	import flash.ui.Mouse;
	//importing classes
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.text.TextFormat;
	import flash.text.TextFormatAlign;
	import flash.text.AntiAliasType;
	import flash.filters.*;
	import flash.net.*;
	
	import flash.utils.*;
	import flash.geom.*;
	import flash.ui.*;
	import caurina.transitions.*;
	import caurina.transitions.properties.FilterShortcuts;
	import caurina.transitions.properties.DisplayShortcuts;
	
	
	public class Item extends MovieClip
	{
		
		public var thumbFeed:String = "";
		public var fileFeed:String = "";
		public var typeFeed:String = "";
		public var descriptionFeed:String = "";
		public var thumbLoader:Loader = new Loader();
		public var added:Boolean = false;
		public var removed:Boolean = false;
		public var thumbFilter:FileFilter = new FileFilter("Compatible Files jpg png swf gif", "*.jpg;*.png;*.swf;*.gif;"); // allow only jpg
		public var fileFilter:FileFilter = new FileFilter("Compatible Files jpg png swf gif flv", "*.jpg;*.png;*.swf;*.gif;*.flv;*.mov;*.mp4"); // allow only jpg
		
		public var index:int = 0;
		
		private var thumbRef:FileReference = new FileReference();
		private var fileRef:FileReference = new FileReference();
		private var currUpload:String = "";
		private var currButton:String = "";
		
		private var fileLoader:BigSWF = new BigSWF();
		private var currPlayer:VideoPlayer = null;
		public function Item()
		{
			thumbFeed = '';
			fileFeed = '';
			typeFeed = '';
			descriptionFeed = '';
			MovieClip(input_mc.getChildAt(0)).text_txt.text = "";
			MovieClip(input_mc.getChildAt(1)).text_txt.text = "";
			MovieClip(input_mc.getChildAt(2)).text_txt.text = "";
			MovieClip(input_mc.getChildAt(3)).text_txt.text = "";
			
			addEventListener(Event.ADDED_TO_STAGE, handleStage);
			
		}
		public function handleStage(e:Event)
		{
			removeEventListener(Event.ADDED_TO_STAGE, handleStage);
			thumbLoader.y = 80;
			added = true;
			
			
			
			
			if(thumbFeed!='')
			thumbLoader.load(new URLRequest(thumbFeed));
			
			
			if (String(thumbFeed).length > 2)
			{
			MovieClip(input_mc.getChildAt(0)).text_txt.text = String(thumbFeed);
			MovieClip(input_mc.getChildAt(1)).text_txt.text = String(fileFeed);
			MovieClip(input_mc.getChildAt(2)).text_txt.text = String(typeFeed);
			MovieClip(input_mc.getChildAt(3)).text_txt.text = String(descriptionFeed);
			}
			addChild(fileLoader);
			
			
			if (thumbFeed != '')
			{
			loadFile(fileFeed, typeFeed);
			}
			
			up1_mc.buttonMode = true;
			up1_mc.mouseChildren = false;
			up2_mc.buttonMode = true;
			up2_mc.mouseChildren = false;
			delete_mc.buttonMode = true;
			
			thumbLoader.contentLoaderInfo.addEventListener(ProgressEvent.PROGRESS, handleThumbProgress);
			thumbLoader.contentLoaderInfo.addEventListener(Event.COMPLETE, handleThumbLoad);
			
			up1_mc.addEventListener(MouseEvent.MOUSE_DOWN, handleUploadBtnMouse);
			up2_mc.addEventListener(MouseEvent.MOUSE_DOWN, handleUploadBtnMouse);
			delete_mc.addEventListener(MouseEvent.MOUSE_DOWN, handleDelete);
			move_up.addEventListener(MouseEvent.MOUSE_DOWN, handleDelete);
			move_down.addEventListener(MouseEvent.MOUSE_DOWN, handleDelete);
			
			
			
			thumbRef.addEventListener(Event.SELECT, handleSelectThumb);
			fileRef.addEventListener(Event.SELECT, handleSelectFile);
		}
		public function handleThumbProgress(e:ProgressEvent)
		{
			Tweener.addTween(MovieClip(input_mc.getChildAt(0)).loader_mc, { scaleX:Math.abs(1 - e.currentTarget.bytesLoaded / e.currentTarget.bytesTotal), time:0.3 } );
			
		}
		public function handleThumbLoad(e:Event)
		{
			Tweener.addTween(MovieClip(input_mc.getChildAt(0)).loader_mc, { scaleX:0, time:0.3 } );
			
			thumbLoader.content.width = 100;
			thumbLoader.content.height = 150;
			addChild(thumbLoader);
		
		}
		public function handleUploadBtnMouse(e:MouseEvent)
		{
			if(e.currentTarget.name=="up1_mc")
			thumbRef.browse([thumbFilter]);
			if (e.currentTarget.name == "up2_mc")
			fileRef.browse([fileFilter]);
			
		}
		public function handleSelectThumb(e:Event)
		{
			
			
			var requestF:URLRequest = new URLRequest(Object(parent).xml.saveThumbPHP);
			thumbRef.upload(requestF);
			thumbRef.addEventListener(Event.COMPLETE, handleCompleteThumb);
		}
		
		public function handleSelectFile(e:Event)
		{
			
			var requestD:URLRequest = new URLRequest(Object(parent).xml.savePicPHP);
			fileRef.upload(requestD);
			fileRef.addEventListener(Event.COMPLETE, handleCompleteFile);
		}
		public function handleCompleteThumb(e:Event)
		{
			MovieClip(input_mc.getChildAt(0)).text_txt.text = "thumbs/" + thumbRef.name;
			
			thumbLoader.unload();
			thumbLoader.load(new URLRequest(MovieClip(input_mc.getChildAt(0)).text_txt.text));
			
		}
		public function handleCompleteFile(e:Event)
		{
			MovieClip(input_mc.getChildAt(1)).text_txt.text = "pics/" + fileRef.name;
			destroyFile();
			
			
			if (String(fileRef.name).search(".flv") != -1 || String(fileRef.name).search(".mov") !=-1)
			{
			loadFile(String("pics/" + fileRef.name), "video")
			}
			else
			{
			if (String(fileRef.name).search(".swf") != -1)
			{
			loadFile(String("pics/" + fileRef.name), "swf")
			}
			else
			{
				loadFile(String("pics/" + fileRef.name), "image")
			}
			}
			
			//thumbLoader.unload();
			//thumbLoader.load(new URLRequest(MovieClip(input_mc.getChildAt(0)).text_txt.text));
			
		}
		public function loadFile(pfeed:String, ptype:String)
		{
			if (ptype == "video" || ptype == "youtube")
			{
				var player_mc:VideoPlayer = new VideoPlayer(pfeed, 300, 200, "true", "", "", ptype, "large");
				currPlayer = player_mc;
				currPlayer.y = 290;
				currPlayer.x = 0;
				addChild(currPlayer);
			}
			else
			{
				if(pfeed!='')
				fileLoader.loadAsset(pfeed, 300, 200);
				fileLoader.y = 290;
				
			}
			
			MovieClip(input_mc.getChildAt(2)).text_txt.text = ptype;
		}
		public function destroyFile()
		{
			if (MovieClip(input_mc.getChildAt(2)).text_txt.text == "youtube" || MovieClip(input_mc.getChildAt(2)).text_txt.text == "video")
			{
				if(currPlayer!=null)
				currPlayer.destroy();
			}
		}
		public function handleDelete(e:MouseEvent)
		{
			if (e.currentTarget.name == "delete_mc")
			{
			destroyFile();
			Object(parent).destroyItem(index);
			}
			if (e.currentTarget.name == "move_up")
			{	
			Object(parent).moveUp(index);
			}
			if (e.currentTarget.name == "move_down")
			{
			Object(parent).moveDown(index);
			}
		}
		
		


	}
}